/*
 * GPS.c
 *
 *  Created on: Apr 18, 2015
 *      Author: Jordan
 */

#include "config.h"
#include "gps.h"
#include "sci.h"
#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "math.h"
#include "board_io.h"

uint8 gps_data, tele_data;
char gps_buffer[100], gps_message[100];
uint32 parse_count = 0;
uint32 parity;
uint32 check_sum_hit = 0;

nmea_gprmc_t nmea_gprmc;
nmea_gpgga_t nmea_gpgga;

void gps_init(){
	sciReceive(scilinREG, 1, &gps_data);
//	sciReceive(sciREG, 1, &tele_data);
}

float32 get_gps_lat(){
	float32 deg = floor(nmea_gprmc.latitude/100);
	float32 lat = deg + (nmea_gprmc.latitude - deg*100)/60;
	return nmea_gprmc.latitude_direction == 'N' ? lat : -lat;
}

float32 get_gps_lon(){
	float32 deg = floor(nmea_gprmc.longitude/100);
	float32 lon = deg + (nmea_gprmc.longitude - deg*100)/60;
	return nmea_gprmc.longitude_direction == 'E' ? lon : -lon;
}

float32 get_gps_heading(){
	return nmea_gprmc.course_over_ground*PI/180;
}

float32 get_gps_speed(){
	return nmea_gprmc.speed_over_ground*0.514444;
}

uint32 get_gps_fix(){
	return nmea_gpgga.fix_quality;
}

uint32 get_gps_sats(){
	return nmea_gpgga.n_satellites;
}

float32 get_gps_hdop(){
	return nmea_gpgga.hdop;
}

float32 get_gps_alt(){
	return nmea_gpgga.altitude_msl;
}

void parse(char data){
	switch(data){
		case '$':
			parse_count = 0;
			parity = 0;
			check_sum_hit = 0;
			gps_buffer[parse_count++] = data;
			break;

		case '*':
			gps_buffer[parse_count++] = data;
			check_sum_hit = 1;
			break;

		case '\n':
			if(gps_buffer[0] == '$'){
				if(parity == 16*from_hex(gps_buffer[parse_count-3]) + from_hex(gps_buffer[parse_count-2])){
					memcpy(gps_message,gps_buffer+1,parse_count-4);
					gps_message[parse_count-5] = ',';
					gps_message[parse_count-4] = 0;
					update_gps();
				}
			}
			break;

		default:
			gps_buffer[parse_count++] = data;
			if(!check_sum_hit){
				parity ^= data;
			}
			break;
	}
	parse_count = parse_count > 99 ? 0 : parse_count;
}

void update_gps(){
	uint32 count = 0;
	char buffer[100], message_type[20];
	char* ptr = strchr(gps_message,',');
	char* ptr_prev = gps_message;

	while(ptr != NULL){
		if(count == 0){
			strncpy(buffer,ptr_prev,ptr-ptr_prev);
			buffer[ptr-ptr_prev] = 0;
			strcpy(message_type, buffer);
		} else {
			strncpy(buffer,ptr_prev + 1,ptr-ptr_prev - 1);
			buffer[ptr-ptr_prev-1] = 0;
		}

		if(!strcmp(message_type, "GPRMC")){
			switch(count){
				case 1:
					nmea_gprmc.time_of_fix = atoi(buffer);
					break;

				case 2:
					nmea_gprmc.receiver_status = *buffer;
					break;

				case 3:
					nmea_gprmc.latitude = atof(buffer);
					break;

				case 4:
					nmea_gprmc.latitude_direction = *buffer;
					break;

				case 5:
					nmea_gprmc.longitude = atof(buffer);
					break;

				case 6:
					nmea_gprmc.longitude_direction = *buffer;
					break;

				case 7:
					nmea_gprmc.speed_over_ground = atof(buffer);
					break;

				case 8:
					nmea_gprmc.course_over_ground = atof(buffer);
					break;

				case 9:
					nmea_gprmc.date_of_fix = atoi(buffer);
					break;

				case 10:
					nmea_gprmc.magnetic_variation = atof(buffer);
					break;

				case 11:
					nmea_gprmc.magnetic_variation_direction = *buffer;
					break;
			}
		}

		if(!strcmp(message_type, "GPGGA")){
			switch(count){
				case 1:
					nmea_gpgga.time_of_fix = atoi(buffer);
					break;

				case 2:
					nmea_gpgga.latitude = atof(buffer);
					break;

				case 3:
					nmea_gpgga.latitude_direction = *buffer;
					break;

				case 4:
					nmea_gpgga.longitude = atof(buffer);
					break;

				case 5:
					nmea_gpgga.longitude_direction = *buffer;
					break;

				case 6:
					nmea_gpgga.fix_quality = atoi(buffer);
					break;

				case 7:
					nmea_gpgga.n_satellites = atoi(buffer);
					break;

				case 8:
					nmea_gpgga.hdop = atof(buffer);
					break;

				case 9:
					nmea_gpgga.altitude_msl = atof(buffer);
					break;

				case 10:
					nmea_gpgga.altitude_msl_units = *buffer;
					break;

				case 11:
					nmea_gpgga.altitude_geoid = atof(buffer);
					break;

				case 12:
					nmea_gpgga.altitude_geoid_units = *buffer;
					break;

				case 13:
					nmea_gpgga.last_update = atof(buffer);
					break;

				case 14:
					nmea_gpgga.station_id = atoi(buffer);
					break;
			}
		}

		ptr_prev = ptr;
		ptr = strchr(ptr+1,',');
		count++;
	}

	toggle_LEDs(0,0,0,1);
}

uint32 from_hex(char a){
	  if (a >= 'A' && a <= 'F')
	    return a - 'A' + 10;
	  else if (a >= 'a' && a <= 'f')
	    return a - 'a' + 10;
	  else
	    return a - '0';
}

void sciNotification(sciBASE_t *sci, uint32 flags)
{
	if(sci == scilinREG){
		parse(gps_data);
//		sciSendByte(sciREG, gps_data);
		sciReceive(scilinREG, 1, &gps_data);
	}
//	if(sci == sciREG){
//		sciSendByte(scilinREG, tele_data);
//		sciReceive(sciREG, 1, &tele_data);
//	}
}
